<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Digesto extends Model 
{

    protected $table = 'dig_general';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('anio', 'nro_orden', 'contenido', 'modifica');
    protected $visible = array('anio', 'nro_orden', 'observacion', 'contenido', 'modifica');

    public function archivos()
    {
        return $this->hasMany('App\Models\Digesto', 'id_dig_general');
    }

}